local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
	
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// selected ndoe
	self.SelectedNode = nil;
	
	// imagelist
	self.ImageList = nil;
	
	// hacky!
//	self.ResizeHack = false;
	
	// our children nodes.
	self.Children = {};
	
	// create a canvas.
	self.Canvas = CtlScrollingCanvas_class:create( self );
	
end


// perform layout.
function PANEL:PerformLayout( )
	// resize our children nodes.
	local ofs = 0;
	local widest = 0;
	
	// perform the tree layout.
	local child;
	for _, child in pairs( self.Children ) do
		_, ofs, widest = child:DoTreeLayout( 0, ofs, widest );
		
	end
	
	// size the scroll area
	self.Canvas:GetCanvas():SetSize( widest, ofs );
	
	// size the canvas.
	self.Canvas:SetSize( self:GetWide() - 4, self:GetTall() - 4 );
	self.Canvas:SetPos( 2, 2 );
	self.Canvas:GetHandle():InvalidateLayout();
	
end


// get node
function PANEL:GetNode( idx )
	return self.Children[idx];

end

// get node count
function PANEL:GetNodeCount(  )
	return table.getn( self.Children );

end



// add node.
function PANEL:CreateNode( )
	// add.
	local node = vgui.Create( "ctl_treenode", self.Canvas:GetCanvas() );
	node:SetTreeview( self );
	
	// add
	table.insert( self.Children, node );
	
	//
	return node;
	
end

// removenode recursive
function PANEL:RemoveNodeRecursive( obj, n )
	// check children;
	local i;
	for i = table.getn( obj.Children ), 1, -1 do
		if( obj.Children[i] == n ) then
			// bye bye!
			table.remove( obj.Children, i );
			
			// cleanup the node and all it's children.
			n:RemoveChildren();
			n:Remove();
			
			// cya!
			break;
			
		else
			self:RemoveNodeRecursive( obj, n );
		
		end
		
	end
	
end

// remove node
function PANEL:RemoveNode( n )
	// selected node?
	if( self.SelectedNode == n ) then
		self.SelectedNode = nil;
		
	end
	
	//
	self:RemoveNodeRecursive( self, n );
	
end



// clear nodes.
function PANEL:ClearNodes( list )
	list = list or self;
	
	// iterate over nodes.
	local node;
	for _, node in pairs( list.Children ) do
		// iterate over it's children.
		self:ClearNodes( node );
		
		// remove
		node:RemoveChildren();
		node:Remove();	
			
	end
	
end

// node expanded
function PANEL:NodeExpanded( node )
	// call event
	if( self.LinkedClass ) then
		//
		local ret = self.LinkedClass:CallEvent( "OnNodeExpanded", node );
		if( ret ) then return true; end
		
	end
	
	// resize
	self:InvalidateLayout();
	
end

// paint
function PANEL:Paint( )
	// frame.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );

	//
	return true;
	
end

// select node
function PANEL:SetSelectedNode( node )
	// call event
	if( self.LinkedClass ) then
		if( self.LinkedClass:CallEvent( "OnNodeSelected", node ) ) then
			return;
			
		end	
	
	end
	
	// select a node.
	if( self.SelectedNode ) then
		// deselect
		self.SelectedNode:SetSelected( false );
		
	end
	
	// select
	node:SetSelected( true );
	self.SelectedNode = node;
	
end

// set image list
function PANEL:SetImageList( list )
	self.ImageList = list;
	
end

// register
vgui.Register( "ctl_treeview", PANEL, "Panel" );



// create app framework control.
CtlTreeview_class 	= Control_class:create( nil, false, "ctl_treeview" );

// set range
function CtlTreeview_class:CreateNode( )
	return self:GetHandle():CreateNode( );
	
end

// set imagelist.
function CtlTreeview_class:SetImageList( list )
	self:GetHandle():SetImageList( list );
	
end

// get node
function CtlTreeview_class:GetNode( idx )
	return self:GetHandle():GetNode( idx );
	
end

// node count
function CtlTreeview_class:GetNodeCount( )
	return self:GetHandle():GetNodeCount( );
	
end

// get selected node
function CtlTreeview_class:GetSelectedNode( )
	return self:GetHandle().SelectedNode;

end
